"use client"

import { TransformedUser } from "../type/transformers";
import { ComponentWithClassNameAndChildren } from "@/types/utils";
import { useApplicationWorkflow } from "@/hooks/use-application-workflow";
import { Button } from "@/components/ui/button";
import { cn } from "@/lib/utils";
import { Trash2 } from "lucide-react";

/**
 * React component to initiate the revoking of priviledges of certain users.
 * Setups up query params and to initial dialog workflow.
 */
export function WorkflowButtonRevoke({ data, children, className }: ComponentWithClassNameAndChildren<{ data: TransformedUser }>) {
  const { setWorkflow } = useApplicationWorkflow()

  return (
    <Button
      variant="outline"
      onClick={() => setWorkflow({
        __tag: "REVOKE_MEMBER_PRIVILEDGES",
        email: data.displayName,
      })}
      className={cn(
        "hover:bg-destructive hover:text-destructive-foreground focus-within:bg-destructive focus-within:text-destructive-foreground focus-visible:!ring-destructive/30 focus-visible:!border-destructive",
        className
      )}
      aria-label={`Revoke priviledges from the member with ${data.displayName} as their email.`}
    >
      {children || (
        <Trash2 className="size-3" />
      )}
    </Button>
  )
}

